﻿using System.Collections.Generic;

namespace Eliza
{
    /// <summary>
    /// The PERHAPS pattern.
    /// </summary>
    /// <seealso cref="Eliza.Pattern" />
    class PerhapsPattern : FormatFreePattern
    {
        #region Constructor

        /// <summary>
        /// Initializes a new instance of the <see cref="PerhapsPattern"/> class.
        /// </summary>
        public PerhapsPattern()
        {
            // Define the responses
            List<string> responses = new List<string>();
            responses.Add("YOU DON'T SEEM QUITE CERTAIN");
            responses.Add("WHY THE UNCERTAIN TONE?");
            responses.Add("CAN'T YOU BE MORE POSITIVE?");
            responses.Add("YOU AREN'T SURE?");
            responses.Add("DON'T YOU KNOW?");

            // Initialize the pattern
            this.Initialize(0, "PERHAPS, MAYBE", responses);
        }

        #endregion
    }
}
